<?php
declare(strict_types=1);

function h(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

function base_path(): string {
  return realpath(__DIR__ . '/..'); // points to .../RemoteCourtLog_FlatPack_v0.1/app
}

function root_path(): string {
  return realpath(__DIR__ . '/..'); // app/ path
}

function project_path(string $rel): string {
  // project is one level up from app/
  $p = realpath(__DIR__ . '/..') . '/../' . ltrim($rel, '/');
  return $p;
}

function load_json(string $path): array {
  if (!file_exists($path)) return [];
  $raw = file_get_contents($path);
  $data = json_decode($raw ?: '[]', true);
  return is_array($data) ? $data : [];
}

function save_json(string $path, array $data): void {
  $dir = dirname($path);
  if (!is_dir($dir)) mkdir($dir, 0775, true);
  $tmp = $path . '.tmp';
  $json = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
  file_put_contents($tmp, $json . PHP_EOL, LOCK_EX);
  rename($tmp, $path);
}

function now_iso(string $tz): string {
  $dt = new DateTime('now', new DateTimeZone($tz));
  return $dt->format('c');
}

function sha256_filehex(string $path): string {
  return hash_file('sha256', $path);
}

function append_line(string $path, string $line): void {
  $dir = dirname($path);
  if (!is_dir($dir)) mkdir($dir, 0775, true);
  file_put_contents($path, $line . PHP_EOL, FILE_APPEND | LOCK_EX);
}

function safe_slug(string $s): string {
  $s = preg_replace('/[^A-Za-z0-9_\-]+/', '-', $s);
  $s = trim($s, '-');
  return $s === '' ? 'NA' : $s;
}
