<?php
declare(strict_types=1);
require_once __DIR__ . '/_common.php';
require_once __DIR__ . '/_auth.php';

function page_header(string $title): void {
  $site = site_cfg();
  $siteName = $site['site_name'] ?? 'Remote Court Log';
  echo "<!doctype html><html lang='en'><head><meta charset='utf-8'>";
  echo "<meta name='viewport' content='width=device-width, initial-scale=1'>";
  echo "<title>" . h($title) . "</title>";
  echo "<style>
    body{font-family:Arial, sans-serif; margin:20px; max-width:1000px;}
    .topbar{display:flex; justify-content:space-between; align-items:center; gap:10px;}
    .card{border:1px solid #ddd; border-radius:10px; padding:16px; margin:12px 0;}
    .grid{display:grid; grid-template-columns:repeat(2,minmax(0,1fr)); gap:12px;}
    label{display:block; font-weight:600; margin-bottom:4px;}
    input, select, textarea{width:100%; padding:8px; border:1px solid #bbb; border-radius:8px;}
    textarea{min-height:90px;}
    .btn{display:inline-block; padding:10px 14px; border-radius:10px; border:1px solid #333; background:#fff; cursor:pointer; text-decoration:none; color:#000;}
    .btn.primary{background:#111; color:#fff; border-color:#111;}
    .btn.danger{background:#b00020; color:#fff; border-color:#b00020;}
    .row{display:flex; gap:10px; flex-wrap:wrap; align-items:center;}
    .muted{color:#666;}
    table{width:100%; border-collapse:collapse;}
    th, td{border-bottom:1px solid #eee; padding:8px; text-align:left; vertical-align:top;}
    .pill{display:inline-block; padding:2px 10px; border:1px solid #ccc; border-radius:999px; font-size:12px; color:#444;}
  </style></head><body>";
  echo "<div class='topbar'><div><h2 style='margin:0'>" . h($siteName) . "</h2><div class='muted'>" . h($title) . "</div></div>";
  echo "<div class='row'>";
  if (is_logged_in()) {
    echo "<a class='btn' href='index.php'>Home</a>";
    echo "<a class='btn' href='new_session.php'>New Session</a>";
    echo "<a class='btn' href='logout.php'>Logout</a>";
  }
  echo "</div></div><hr>";
}

function page_footer(): void {
  echo "<hr><div class='muted'>Flat-Pack v0.1 (local use). Store official court records in your court system.</div></body></html>";
}
