<?php
declare(strict_types=1);
require_once __DIR__ . '/_common.php';
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout.php';
require_once __DIR__ . '/_session_helpers.php';
require_login();

$folder = (string)($_GET['folder'] ?? '');
if ($folder === '') { header('Location: index.php'); exit; }
$spath = session_path($folder);
$attachDir = $spath . "/attachments";
if (!is_dir($attachDir)) mkdir($attachDir, 0775, true);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
    $f = $_FILES['file'];
    if ($f['error'] === UPLOAD_ERR_OK) {
        $safe = preg_replace('/[^A-Za-z0-9_\.\-]/','-',basename($f['name']));
        move_uploaded_file($f['tmp_name'], $attachDir . "/" . $safe);
        write_audit('upload_attachment', $folder, ['file'=>$safe]);
        refresh_daily_hash_chain();
    }
    header("Location: attachments.php?folder=" . urlencode($folder));
    exit;
}

$files = array_diff(scandir($attachDir), ['.','..']);

page_header('Attachments');
echo "<div class='card'><div class='row'>
<a class='btn' href='view_session.php?folder=" . h(urlencode($folder)) . "'>Back</a>
</div></div>";

echo "<div class='card'><h3>Upload Attachment</h3>
<form method='post' enctype='multipart/form-data'>
<input type='file' name='file' required>
<br><br>
<button class='btn primary' type='submit'>Upload</button>
</form></div>";

echo "<div class='card'><h3>Existing Files</h3>";
if (!$files) {
    echo "<p class='muted'>No attachments yet.</p>";
} else {
    echo "<ul>";
    foreach ($files as $file) {
        echo "<li>" . h($file) . "</li>";
    }
    echo "</ul>";
}
echo "</div>";

page_footer();
