<?php
declare(strict_types=1);
require_once __DIR__ . '/_common.php';
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout.php';
require_once __DIR__ . '/_session_helpers.php';
require_login();

$folder = (string)($_GET['folder'] ?? '');
if ($folder === '') { header('Location: index.php'); exit; }
$spath = session_path($folder);
$site = site_cfg();
$tz = $site['timezone'] ?? 'UTC';

$cfg = load_json(project_path('config/checklists.json'));
$preItems = $cfg['pre_session'] ?? [];
$postItems = $cfg['post_session'] ?? [];

$data = load_json($spath . "/checklist.json");
if (!isset($data['pre_session']) || !is_array($data['pre_session'])) $data['pre_session'] = [];
if (!isset($data['post_session']) || !is_array($data['post_session'])) $data['post_session'] = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $pre = [];
  foreach ($preItems as $i => $text) {
    $k = "pre_" . $i;
    $pre[] = ['text' => (string)$text, 'done' => isset($_POST[$k]), 'ts' => now_iso($tz)];
  }
  $post = [];
  foreach ($postItems as $i => $text) {
    $k = "post_" . $i;
    $post[] = ['text' => (string)$text, 'done' => isset($_POST[$k]), 'ts' => now_iso($tz)];
  }
  $data = ['pre_session' => $pre, 'post_session' => $post, 'updated_at' => now_iso($tz)];
  save_json($spath . "/checklist.json", $data);
  write_audit('update_checklist', $folder, []);
  refresh_daily_hash_chain();
  header("Location: checklist.php?folder=" . urlencode($folder));
  exit;
}

page_header('Checklist');

echo "<div class='card'><div class='row'>
  <a class='btn' href='view_session.php?folder=" . h(urlencode($folder)) . "'>Back</a>
</div></div>";

echo "<div class='card'><form method='post'>";
echo "<h3 style='margin-top:0'>Pre-Session</h3>";
foreach ($preItems as $i => $text) {
  $done = false;
  if (isset($data['pre_session'][$i]['done'])) $done = (bool)$data['pre_session'][$i]['done'];
  echo "<div style='margin:8px 0'><label style='font-weight:500'>";
  echo "<input type='checkbox' name='pre_" . h((string)$i) . "' " . ($done ? "checked" : "") . " style='width:auto; transform:scale(1.2); margin-right:10px'>";
  echo h((string)$text) . "</label></div>";
}
echo "<hr><h3>Post-Session</h3>";
foreach ($postItems as $i => $text) {
  $done = false;
  if (isset($data['post_session'][$i]['done'])) $done = (bool)$data['post_session'][$i]['done'];
  echo "<div style='margin:8px 0'><label style='font-weight:500'>";
  echo "<input type='checkbox' name='post_" . h((string)$i) . "' " . ($done ? "checked" : "") . " style='width:auto; transform:scale(1.2); margin-right:10px'>";
  echo h((string)$text) . "</label></div>";
}
echo "<br><button class='btn primary' type='submit'>Save Checklist</button>";
echo "</form></div>";

page_footer();
