<?php
declare(strict_types=1);
require_once __DIR__ . '/_common.php';
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_session_helpers.php';
require_login();

$f = (string)($_GET['f'] ?? '');
$map = [
  'index_csv' => index_csv_path(),
  'index_ndjson' => index_ndjson_path(),
  'audit' => audit_path(),
  'hashes' => daily_hashes_path()
];
if (!isset($map[$f])) die('Unknown file');
$path = $map[$f];
if (!file_exists($path)) die('Not found');

$bn = basename($path);
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . $bn . '"');
header('Content-Length: ' . filesize($path));
readfile($path);
exit;
