<?php
declare(strict_types=1);
require_once __DIR__ . '/_common.php';
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_session_helpers.php';
require_login();

$folder = (string)($_GET['folder'] ?? '');
if ($folder === '') die('Missing folder');

$spath = session_path($folder);
if (!is_dir($spath)) die('Not found');

$zipName = $folder . ".zip";
$tmp = sys_get_temp_dir() . DIRECTORY_SEPARATOR . $zipName;

$zip = new ZipArchive();
if ($zip->open($tmp, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== TRUE) {
  die('Could not create ZIP');
}

$it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($spath, FilesystemIterator::SKIP_DOTS));
foreach ($it as $file) {
  $filePath = (string)$file;
  $rel = substr($filePath, strlen($spath) + 1);
  $zip->addFile($filePath, $folder . "/" . $rel);
}
$zip->close();

write_audit('export_session_zip', $folder, []);
refresh_daily_hash_chain();

header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="' . $zipName . '"');
header('Content-Length: ' . filesize($tmp));
readfile($tmp);
@unlink($tmp);
exit;
