<?php
declare(strict_types=1);
require_once __DIR__ . '/_common.php';
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout.php';
require_once __DIR__ . '/_session_helpers.php';
require_login();

$folder = (string)($_GET['folder'] ?? '');
if ($folder === '') { header('Location: index.php'); exit; }
$spath = session_path($folder);

$site = site_cfg();
$tz = $site['timezone'] ?? 'UTC';

$data = load_json($spath . "/incidents.json");
$list = $data['incidents'] ?? [];
if (!is_array($list)) $list = [];

$types = ["No-show","Disruption","Tech failure","Safety issue","Suspected coercion","Other"];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $inc = [
    'created_at' => now_iso($tz),
    'type' => (string)($_POST['type'] ?? 'Other'),
    'description' => (string)($_POST['description'] ?? ''),
    'actions_taken' => (string)($_POST['actions_taken'] ?? ''),
    'escalated_to' => (string)($_POST['escalated_to'] ?? ''),
    'outcome' => (string)($_POST['outcome'] ?? ''),
  ];
  $list[] = $inc;
  save_json($spath . "/incidents.json", ['incidents' => $list]);
  write_audit('add_incident', $folder, ['type'=>$inc['type']]);
  refresh_daily_hash_chain();
  header("Location: incidents.php?folder=" . urlencode($folder));
  exit;
}

page_header('Incidents');

echo "<div class='card'><div class='row'>
  <a class='btn' href='view_session.php?folder=" . h(urlencode($folder)) . "'>Back</a>
</div></div>";

echo "<div class='card'><h3 style='margin-top:0'>Add Incident</h3>";
echo "<form method='post'><div class='grid'>";
echo "<div><label>Type</label><select name='type'>";
foreach ($types as $t) echo "<option value='" . h($t) . "'>" . h($t) . "</option>";
echo "</select></div>";
echo "<div><label>Escalated To</label><input name='escalated_to' placeholder='Court clerk / judge / supervisor'></div>";
echo "</div>";
echo "<div style='margin-top:10px'><label>Description</label><textarea name='description' placeholder='What happened'></textarea></div>";
echo "<div style='margin-top:10px'><label>Actions Taken</label><textarea name='actions_taken' placeholder='Steps taken'></textarea></div>";
echo "<div style='margin-top:10px'><label>Outcome</label><textarea name='outcome' placeholder='Resolved / rescheduled / removed / etc.'></textarea></div>";
echo "<br><button class='btn primary' type='submit'>Add Incident</button></form>";
echo "</div>";

echo "<div class='card'><h3 style='margin-top:0'>Incident Log</h3>";
if (!$list) {
  echo "<p class='muted'>No incidents recorded.</p>";
} else {
  echo "<table><thead><tr><th>When</th><th>Type</th><th>Description</th></tr></thead><tbody>";
  foreach ($list as $inc) {
    echo "<tr>";
    echo "<td>" . h((string)($inc['created_at'] ?? '')) . "</td>";
    echo "<td>" . h((string)($inc['type'] ?? '')) . "</td>";
    echo "<td>" . h((string)($inc['description'] ?? '')) . "</td>";
    echo "</tr>";
  }
  echo "</tbody></table>";
}
echo "</div>";

page_footer();
