<?php
declare(strict_types=1);
require_once __DIR__ . '/_common.php';
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout.php';
require_login();

$idxCsv = project_path('indexes/sessions.csv');
$rows = [];
if (file_exists($idxCsv)) {
  $f = fopen($idxCsv, 'r');
  if ($f) {
    $header = fgetcsv($f);
    while (($r = fgetcsv($f)) !== false) {
      $rows[] = array_combine($header, $r);
    }
    fclose($f);
  }
}

page_header('Dashboard');
echo "<div class='card'>";
echo "<div class='row'><a class='btn primary' href='new_session.php'>Create New Session</a>";
echo "<a class='btn' href='export_all.php'>Export Indexes</a></div>";
echo "<p class='muted'>Recent sessions are listed below. Use the CSV in <code>indexes/sessions.csv</code> for filtering/search in Excel.</p>";
echo "</div>";

echo "<div class='card'>";
echo "<h3 style='margin-top:0'>Recent Sessions</h3>";
if (!$rows) {
  echo "<p class='muted'>No sessions yet.</p>";
} else {
  $rows = array_reverse($rows);
  $rows = array_slice($rows, 0, 50);
  echo "<table><thead><tr>
    <th>Date</th><th>Case</th><th>Type</th><th>Site</th><th>Room</th><th>Actions</th>
  </tr></thead><tbody>";
  foreach ($rows as $r) {
    $folder = $r['folder'] ?? '';
    $url = "view_session.php?folder=" . urlencode($folder);
    echo "<tr>";
    echo "<td>" . h($r['date'] ?? '') . "</td>";
    echo "<td>" . h($r['case_number'] ?? '') . "</td>";
    echo "<td>" . h($r['hearing_type'] ?? '') . "</td>";
    echo "<td>" . h($r['site_code'] ?? '') . "</td>";
    echo "<td>" . h($r['room'] ?? '') . "</td>";
    echo "<td class='row'><a class='btn' href='" . h($url) . "'>Open</a></td>";
    echo "</tr>";
  }
  echo "</tbody></table>";
}
echo "</div>";
page_footer();
