<?php
declare(strict_types=1);
require_once __DIR__ . '/_common.php';
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout.php';

if (is_logged_in()) { header('Location: index.php'); exit; }

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $user = (string)($_POST['user'] ?? '');
  $pass = (string)($_POST['pass'] ?? '');
  if (login_attempt($user, $pass)) {
    set_login_cookie();
    header('Location: index.php');
    exit;
  } else {
    $error = 'Invalid login.';
  }
}

page_header('Login');
echo "<div class='card' style='max-width:520px'>";
if ($error) echo "<div class='pill' style='border-color:#b00020;color:#b00020'>" . h($error) . "</div><br><br>";
echo "<form method='post'>
  <div class='grid'>
    <div><label>Username</label><input name='user' required></div>
    <div><label>Password</label><input type='password' name='pass' required></div>
  </div>
  <br><button class='btn primary' type='submit'>Login</button>
</form>";
echo "<p class='muted'>Tip: Change the default password in <code>config/auth.json</code>.</p>";
echo "</div>";
page_footer();
