<?php
declare(strict_types=1);
require_once __DIR__ . '/_common.php';
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout.php';
require_once __DIR__ . '/_session_helpers.php';
require_login();

$folder = (string)($_GET['folder'] ?? '');
if ($folder === '') { header('Location: index.php'); exit; }
$spath = session_path($folder);

$site = site_cfg();
$tz = $site['timezone'] ?? 'UTC';
$fields = load_json(project_path('config/fields.json'));
$pfields = $fields['participant_fields'] ?? [];

$data = load_json($spath . "/participants.json");
$list = $data['participants'] ?? [];
if (!is_array($list)) $list = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $p = ['created_at' => now_iso($tz)];
  foreach ($pfields as $f) {
    $key = (string)($f['key'] ?? '');
    if ($key === '') continue;
    $type = (string)($f['type'] ?? 'text');
    if ($type === 'checkbox') {
      $p[$key] = isset($_POST[$key]) ? true : false;
    } else {
      $p[$key] = (string)($_POST[$key] ?? '');
    }
  }
  $list[] = $p;
  save_json($spath . "/participants.json", ['participants' => $list]);
  write_audit('add_participant', $folder, ['full_name'=>$p['full_name'] ?? '']);
  refresh_daily_hash_chain();
  header("Location: participants.php?folder=" . urlencode($folder));
  exit;
}

page_header('Participants');

echo "<div class='card'><div class='row'>
  <a class='btn' href='view_session.php?folder=" . h(urlencode($folder)) . "'>Back</a>
</div></div>";

echo "<div class='card'><h3 style='margin-top:0'>Add Participant</h3>";
echo "<form method='post'><div class='grid'>";
foreach ($pfields as $f) {
  $key = (string)($f['key'] ?? '');
  $label = (string)($f['label'] ?? $key);
  $type = (string)($f['type'] ?? 'text');
  $req = (bool)($f['required'] ?? false);

  echo "<div>";
  echo "<label>" . h($label) . ($req ? " (required)" : "") . "</label>";
  if ($type === 'select') {
    echo "<select name='" . h($key) . "'" . ($req ? " required" : "") . ">";
    echo "<option value=''>-- select --</option>";
    foreach (($f['options'] ?? []) as $o) echo "<option value='" . h((string)$o) . "'>" . h((string)$o) . "</option>";
    echo "</select>";
  } elseif ($type === 'checkbox') {
    echo "<input type='checkbox' name='" . h($key) . "' style='width:auto; transform:scale(1.2)'>";
  } elseif ($type === 'time') {
    echo "<input type='time' name='" . h($key) . "'>";
  } else {
    echo "<input name='" . h($key) . "'" . ($req ? " required" : "") . ">";
  }
  echo "</div>";
}
echo "</div><br><button class='btn primary' type='submit'>Add</button></form>";
echo "</div>";

echo "<div class='card'><h3 style='margin-top:0'>Current Participants</h3>";
if (!$list) {
  echo "<p class='muted'>None yet.</p>";
} else {
  echo "<table><thead><tr><th>Name</th><th>Role</th><th>ID Verified</th><th>Arrival</th><th>Departure</th></tr></thead><tbody>";
  foreach ($list as $p) {
    echo "<tr>";
    echo "<td>" . h((string)($p['full_name'] ?? '')) . "</td>";
    echo "<td>" . h((string)($p['role'] ?? '')) . "</td>";
    echo "<td>" . (($p['id_verified'] ?? false) ? "Yes" : "No") . "</td>";
    echo "<td>" . h((string)($p['arrival_time'] ?? '')) . "</td>";
    echo "<td>" . h((string)($p['departure_time'] ?? '')) . "</td>";
    echo "</tr>";
  }
  echo "</tbody></table>";
}
echo "</div>";

page_footer();
