<?php
declare(strict_types=1);
require_once __DIR__ . '/_common.php';
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_session_helpers.php';
require_login();

$folder = (string)($_GET['folder'] ?? '');
if ($folder === '') die('Missing folder');
$spath = session_path($folder);

$session = load_json($spath . "/session.json");
$participants = load_json($spath . "/participants.json");
$incidents = load_json($spath . "/incidents.json");

header("Content-Type: text/html; charset=utf-8");
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Session Summary</title>
<style>
body{font-family:Arial;margin:40px;}
h2{margin-top:0;}
table{width:100%;border-collapse:collapse;margin-top:10px;}
th,td{border-bottom:1px solid #ddd;padding:8px;text-align:left;}
@media print {.noprint{display:none;}}
</style>
</head>
<body>
<div class="noprint"><button onclick="window.print()">Print</button></div>
<h2>Session Summary</h2>

<p><strong>Case:</strong> <?php echo h($session['fields']['case_number'] ?? ''); ?></p>
<p><strong>Type:</strong> <?php echo h($session['fields']['hearing_type'] ?? ''); ?></p>
<p><strong>Date:</strong> <?php echo h($session['session']['date'] ?? ''); ?></p>
<p><strong>Room:</strong> <?php echo h($session['meta']['room'] ?? ''); ?></p>

<h3>Participants</h3>
<table>
<tr><th>Name</th><th>Role</th></tr>
<?php foreach (($participants['participants'] ?? []) as $p): ?>
<tr>
<td><?php echo h($p['full_name'] ?? ''); ?></td>
<td><?php echo h($p['role'] ?? ''); ?></td>
</tr>
<?php endforeach; ?>
</table>

<h3>Incidents</h3>
<table>
<tr><th>When</th><th>Type</th><th>Description</th></tr>
<?php foreach (($incidents['incidents'] ?? []) as $i): ?>
<tr>
<td><?php echo h($i['created_at'] ?? ''); ?></td>
<td><?php echo h($i['type'] ?? ''); ?></td>
<td><?php echo h($i['description'] ?? ''); ?></td>
</tr>
<?php endforeach; ?>
</table>

</body>
</html>
