<?php
declare(strict_types=1);
require_once __DIR__ . '/../_common.php';

$authPath = project_path('config/auth.json');
$cfg = load_json($authPath);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $new = (string)($_POST['new_pass'] ?? '');
  if ($new === '') { die('Password required'); }
  $salt = (string)($cfg['salt'] ?? '');
  $cfg['password_sha256'] = hash('sha256', $salt . $new);
  save_json($authPath, $cfg);
  echo "Updated config/auth.json. You can close this page.";
  exit;
}

echo "<!doctype html><meta charset='utf-8'><title>Make Password Hash</title>";
echo "<h2>Set Admin Password</h2>";
echo "<form method='post'><label>New Password</label><br>";
echo "<input type='password' name='new_pass' required style='padding:8px;width:320px'>";
echo "<br><br><button type='submit' style='padding:10px 14px'>Update</button></form>";
echo "<p>Writes a new hash into <code>config/auth.json</code>.</p>";
