<?php
declare(strict_types=1);
require_once __DIR__ . '/_common.php';
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout.php';
require_once __DIR__ . '/_session_helpers.php';
require_login();

$folder = (string)($_GET['folder'] ?? '');
if ($folder === '') { header('Location: index.php'); exit; }

$spath = session_path($folder);
$session = load_json($spath . "/session.json");
$participants = load_json($spath . "/participants.json");
$checklist = load_json($spath . "/checklist.json");
$incidents = load_json($spath . "/incidents.json");

page_header('Session: ' . $folder);

$case = $session['fields']['case_number'] ?? '';
$type = $session['fields']['hearing_type'] ?? '';
$siteCode = $session['meta']['site_code'] ?? '';
$room = $session['meta']['room'] ?? '';
$date = $session['session']['date'] ?? '';
$stime = $session['session']['start_time'] ?? '';
$etime = $session['session']['end_time'] ?? '';

echo "<div class='card'>";
echo "<div class='row'>";
echo "<span class='pill'>Case: " . h((string)$case) . "</span>";
echo "<span class='pill'>Type: " . h((string)$type) . "</span>";
echo "<span class='pill'>Date: " . h((string)$date) . " " . h((string)$stime) . "</span>";
echo "<span class='pill'>Site: " . h((string)$siteCode) . "</span>";
echo "<span class='pill'>Room: " . h((string)$room) . "</span>";
echo "</div>";
echo "<div class='row' style='margin-top:10px'>";
echo "<a class='btn' href='participants.php?folder=" . h(urlencode($folder)) . "'>Participants</a>";
echo "<a class='btn' href='checklist.php?folder=" . h(urlencode($folder)) . "'>Checklist</a>";
echo "<a class='btn' href='incidents.php?folder=" . h(urlencode($folder)) . "'>Incidents</a>";
echo "<a class='btn primary' href='export_session.php?folder=" . h(urlencode($folder)) . "'>Export Session ZIP</a>";
echo "<a class='btn' href='attachments.php?folder=" . h(urlencode($folder)) . "'>Attachments</a>";
echo "<a class='btn' href='print_summary.php?folder=" . h(urlencode($folder)) . "' target='_blank'>Printable Summary</a>";

echo "</div>";
echo "</div>";

echo "<div class='card'><h3 style='margin-top:0'>Session Fields</h3><table><tbody>";
foreach (($session['fields'] ?? []) as $k => $v) {
  echo "<tr><th style='width:240px'>" . h((string)$k) . "</th><td>" . h((string)$v) . "</td></tr>";
}
echo "</tbody></table></div>";

echo "<div class='card'><h3 style='margin-top:0'>Quick Summary</h3>";
$pc = count($participants['participants'] ?? []);
$ic = count($incidents['incidents'] ?? []);
echo "<p class='muted'>Participants: <b>" . h((string)$pc) . "</b> | Incidents: <b>" . h((string)$ic) . "</b></p>";
echo "<p class='muted'>Session folder: <code>" . h($spath) . "</code></p>";
echo "</div>";

page_footer();
